#!/bin/sh

# Copyright IBM Corp. 2001
# Configuration Based Server Launcher

# Launch Arguments:
#
#

# Bootstrap values ...

binDir=`dirname $0`
. "$binDir/setupCmdLine.sh"

# Debugging defaults ...

DEFAULT_OLT_HOST=localhost
DEFAULT_OLT_PORT=2102
DEFAULT_JDWP_PORT=7777

# Setup the initial java invocation;

PLATFORM=`/bin/uname`
WAS_LIBPATH=$WAS_HOME/bin
case $PLATFORM in
  AIX)
    LIBPATH="$WAS_LIBPATH:$LIBPATH"
    export LIBPATH ;;
  Linux)
    LD_LIBRARY_PATH="$WAS_LIBPATH:$LD_LIBRARY_PATH"
    export LD_LIBRARY_PATH ;;
  SunOS)
    LD_LIBRARY_PATH="$WAS_LIBPATH:$LD_LIBRARY_PATH"
    export LD_LIBRARY_PATH ;;
  HP-UX)
    SHLIB_PATH="$WAS_LIBPATH:$SHLIB_PATH"
    export SHLIB_PATH ;;
esac


"$JAVA_HOME/bin/java" \
  -Dws.def.olt.host=$DEFAULT_OLT_HOST \
  -Dws.def.olt.port=$DEFAULT_OLT_PORT \
  -Dws.def.jdwp.port=$DEFAULT_JDWP_PORT \
  "-Xbootclasspath/p:$WAS_BOOTCLASSPATH" \
  -Xms64m -Xmx256m \
  -Djava.security.auth.login.config="$WAS_HOME/properties/wsjaas.conf" \
  -Djava.security.policy="$WAS_HOME/properties/server.policy" \
  -DenableJava2Security=true \
  -Dcom.ibm.itp.location="$ITP_LOC" \
  -Dserver.root="$WAS_HOME" \
  -Dws.ext.dirs="$WAS_EXT_DIRS" \
  -classpath "$WAS_CLASSPATH" \
  "$SERVERSAS" \
  com.ibm.ws.bootstrap.WSLauncher \
  com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler "$CONFIG_ROOT" "-cell.name" "$WAS_CELL" "-node.name" "$WAS_NODE" "$@"
